#include <algorithm>
#include <array>
#include <cassert>
#include <iostream>
#include <ostream>
#include <vector>
using namespace std;

using ll = long long;
using ull = unsigned long long;

const ull HALF = 12;

template <ll MOD>
struct modular {
    ll x;
    modular() : x(0) {}
    modular(ll _x) {
        x = _x % MOD;
        if (x < 0) {
            x += MOD;
        }
    }
    bool operator==(const modular &a) const { return x == a.x; }
    modular operator+(const modular &a) const { return modular(x + a.x); }
    modular operator*(const modular &b) const { return modular(x * b.x); }
    modular operator-(const modular &b) const { return modular(x - b.x); }
    modular operator+=(const modular &b) { return *this = *this + b; }
    modular operator-=(const modular &b) { return *this = *this - b; }
    modular operator*=(const modular &b) { return *this = *this * b; }
};

namespace dp {
    // 决定以后不再开全局变量。

    using mll = modular<998244353>;

    struct result {
        ll minn;
        mll cnt;
        result() : minn(0x3f3f3f3f3f3f3f3f), cnt(0) {}
        result(ll _minn, mll _cnt) : minn(_minn), cnt(_cnt) {}
        bool operator<(const result &b) const { return minn < b.minn; }
        result operator+(const result &b) const {
            if (minn == b.minn) {
                return {minn, cnt + b.cnt};
            }
            else {
                return min(*this, b);
            }
        }
        result operator+=(const result &b) { return *this = *this + b; }
    };

    struct item {
        ll w, v;
        bool operator<(const item &b) const { return v < b.v; }
    };

    vector<item> l, r;
    array<ll, 1 << HALF> subset_sum_l, subset_sum_r, max_l, max_r;
    ll W;
    array<vector<ull>, 1 << HALF> subset_order_l, subset_order_r;

    ull lowbit(ull x) { return x & -x; }

    void prework() {
        sort(l.begin(), l.end());
        ull size_l = l.size() / 2, size_r = l.size() - size_l;
        // 切成两半。
        r.resize(size_r);
        copy(l.begin() + size_l, l.end(), r.begin());
        l.resize(size_l);
        for (ull i = 1; i < 1ull << l.size(); i++) {
            ull last = __lg(lowbit(i));
            subset_sum_l[i] = subset_sum_l[i ^ (1 << last)] + l[last].w;
            max_l[i] = max(max_l[i ^ (1 << last)], l[last].v);
        }
        for (ull i = 1; i < 1ull << r.size(); i++) {
            ull last = __lg(lowbit(i));
            subset_sum_r[i] = subset_sum_r[i ^ (1 << last)] + r[last].w;
            max_r[i] = max(max_r[i ^ (1 << last)], r[last].v);
        }

        for (ull stat = 0; stat < 1ull << r.size(); stat++) {
            /**
             * 自己不能带。这个表示在右侧什么都不选，代价是左侧的最大值。
             */
            for (ull subset = (stat - 1) & stat; subset;
                 subset = (subset - 1) & stat) {
                if (subset_sum_r[subset ^ stat] <= W) {
                    subset_order_r[stat].push_back(subset);
                }
            }
            if (stat != 0 && subset_sum_r[0 ^ stat] <= W) {
                // 如果是 0 的话不能包括自己
                subset_order_r[stat].push_back(0);
            }
            sort(subset_order_r[stat].begin(), subset_order_r[stat].end(),
                 [&stat](ull a, ull b) {
                     return subset_sum_r[a ^ stat] < subset_sum_r[b ^ stat];
                 });
        }
        for (ull stat = 0; stat < 1ull << l.size(); stat++) {
            for (ull superset = (stat + 1) | stat;
                 superset < (1ull << l.size());
                 superset = (superset + 1) | stat) {
                if (subset_sum_l[superset ^ stat] > W ||
                    lowbit(superset) != lowbit(superset ^ stat)) {
                    continue;
                }
                subset_order_l[stat].push_back(superset);
            }
            sort(subset_order_l[stat].begin(), subset_order_l[stat].end(),
                 [&stat](ull a, ull b) {
                     return subset_sum_l[stat ^ a] > subset_sum_l[stat ^ b];
                 });
        }
        return;
    }

    namespace solve1 {
        // 两端不相交的情况。
        array<result, 1 << HALF> dp_l, dp_r;

        result calculate() {
            dp_l.fill({0x3f3f3f3f3f3f3f3f, 0});

            dp_l[0].cnt = 1;
            dp_l[0].minn = 0;
            for (ull stat = 1; stat < 1ull << l.size(); stat++) {
                for (ull prev_stat = stat; prev_stat;
                     prev_stat = (prev_stat - 1) & stat) {
                    if (subset_sum_l[prev_stat] <= W &&
                        lowbit(prev_stat) == lowbit(stat)) {
                        result new_stat = dp_l[stat ^ prev_stat];
                        new_stat.minn += max_l[prev_stat];
                        dp_l[stat] += new_stat;
                    }
                }
            }
            dp_r.fill({0x3f3f3f3f3f3f3f3f, 0});
            dp_r[0].cnt = 1;
            dp_r[0].minn = 0;
            for (ull stat = 1; stat < 1ull << r.size(); stat++) {
                for (ull prev_stat = stat; prev_stat;
                     prev_stat = (prev_stat - 1) & stat) {
                    if (subset_sum_r[prev_stat] <= W &&
                        lowbit(prev_stat) == lowbit(stat)) {
                        result new_stat = dp_r[stat ^ prev_stat];
                        new_stat.minn += max_r[prev_stat];
                        dp_r[stat] += new_stat;
                    }
                }
            }
            return {
                dp_l[(1 << l.size()) - 1].minn + dp_r[(1 << r.size()) - 1].minn,
                dp_l[(1 << l.size()) - 1].cnt * dp_r[(1 << r.size()) - 1].cnt,
            };
        }
    } // namespace solve1

    namespace solve2 {
        // 跨过端点的情况。
        array<array<result, 1 << HALF>, 1 << HALF> dp;

        result calculate() {
            // 实际上左边部分不需要从之前转移。可以从右端点的 0 转移过来。
            for (ull stat_r = 0; stat_r < (1ull << r.size()); stat_r++) {
                dp[0][stat_r] += solve1::dp_r[stat_r];
            }
            for (ull stat_l = 0; stat_l < (1ull << l.size()); stat_l++) {
                for (ull stat_r = 0; stat_r < (1ull << r.size()); stat_r++) {
                    ull ptr_r = 0;
                    result res{0x3f3f3f3f3f3f3f3f, 0};
                    for (ull i = 0; i < subset_order_l[stat_l].size(); i++) {
                        while (ptr_r < subset_order_r[stat_r].size() &&
                               subset_sum_r[subset_order_r[stat_r][ptr_r] ^
                                            stat_r] +
                                       subset_sum_l[subset_order_l[stat_l][i] ^
                                                    stat_l] <=
                                   W) {
                            auto new_res =
                                dp[stat_l][subset_order_r[stat_r][ptr_r]];
                            new_res.minn +=
                                max_r[subset_order_r[stat_r][ptr_r] ^ stat_r];
                            res += new_res;
                            ptr_r++;
                        }
                        dp[subset_order_l[stat_l][i]][stat_r] += res;
                        {
                            // 右侧什么都不选的情况。
                            result new_res = dp[stat_l][stat_r];
                            new_res.minn +=
                                max_l[subset_order_l[stat_l][i] ^ stat_l];
                            dp[subset_order_l[stat_l][i]][stat_r] += new_res;
                        }
                    }
                }
            }
            return dp[(1 << l.size()) - 1][(1 << r.size()) - 1];
        }
    } // namespace solve2
} // namespace dp

int main() {
    ull n;
    cin >> n >> dp::W;
    for (ull i = 0; i < n; i++) {
        dp::item it;
        cin >> it.w >> it.v;
        assert(it.w > 0);
        assert(it.v > 0);
        dp::l.push_back(it);
    }
    dp::prework();
    dp::solve1::calculate();
    auto ans2 = dp::solve2::calculate();
    cout << ans2.minn << " " << ans2.cnt.x << endl;
    // ans 已经包含了 ans1。
    return 0;
}
